DROP PROCEDURE [hips].[HpiiLookupAuditInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:       Philip Stalley-Gordon
-- Create date: 15/11/2013
-- Description:   Inserts a new record into the HpiiLookupAlert Table
-- =============================================
CREATE PROCEDURE [hips].[HpiiLookupAuditInsert] 
(
	@HpiiNumber  VARCHAR(50) = NULL,
	@HpiiStatusId INT = NULL,
	@RegistrationId VARCHAR(20) = NULL,
	@FamilyName VARCHAR(40),
	@GivenNames VARCHAR(500) = NULL,
	@DateOfBirth DATETIME = NULL,
	@Sex VARCHAR(1) = NULL,
	@AustralianState VARCHAR(5) = NULL,
	@Postcode VARCHAR(4) = NULL,
	@CountryId INT = NULL,
	@BatchItemId INT = NULL,
	@BatchId INT = NULL,
	@Message VARCHAR(200) = NULL,
	@OperatorHpiI VARCHAR(16) = NULL,
	@HpiO VARCHAR(16),
	@Operator VARCHAR(100),
	@IdentifierType VARCHAR(40) = NULL,
	@IdentifierValue VARCHAR(128) = NULL,
	@HiWebServiceName VARCHAR(40),
	@HiWebServiceVersion VARCHAR(10),
	@ServiceMessageRequestID VARCHAR(50) = NULL,
	@ServiceMessageResponseID VARCHAR(50) = NULL,
	@Request xml = NULL,
	@Response xml = NULL,
	@UserModified VARCHAR(256)
)
AS
BEGIN
	SET NOCOUNT ON
	
	DECLARE  @intErrorCode INT,
			 @HpiiLookupAuditId INT,
			 @SexId INT,
			 @AustralianStateId INT

	SELECT @SexId = SexId 
	FROM hips.Sex
	WHERE Code = @Sex

	SELECT @AustralianStateId = StateId 
	FROM hips.State
	WHERE Code = @AustralianState

	SET @intErrorCode = 0
	
	INSERT INTO [hips].[HpiiLookupAudit]
		   ([HpiiNumber]
		   ,[HpiiStatusId]
		   ,[RegistrationId]
		   ,[FamilyName]
		   ,[GivenNames]
		   ,[DateOfBirth]
		   ,[SexId]
		   ,[AustralianStateId]
		   ,[Postcode]
		   ,[CountryId]
		   ,[BatchItemId]
		   ,[BatchId]
		   ,[Message]
		   ,[OperatorHpiI]
		   ,[HpiO]
		   ,[Operator]
		   ,[IdentifierType]
		   ,[IdentifierValue]
		   ,[HiWebServiceName]
		   ,[HiWebServiceVersion]
		   ,[ServiceMessageRequestID]
		   ,[ServiceMessageResponseID]
		   ,[Request]
		   ,[Response]
		   ,[DateCreated]
		   ,[UserCreated]
		   ,[DateModified]
		   ,[UserModified])
	VALUES
		   (@HpiiNumber
		   ,@HpiiStatusId
		   ,@RegistrationId
		   ,@FamilyName
		   ,@GivenNames
		   ,@DateOfBirth
		   ,@SexId
		   ,@AustralianStateId
		   ,@Postcode
		   ,@CountryId
		   ,@BatchItemId
		   ,@BatchId
		   ,@Message
		   ,@OperatorHpiI
		   ,@HpiO
		   ,@Operator
		   ,@IdentifierType
		   ,@IdentifierValue
		   ,@HiWebServiceName
		   ,@HiWebServiceVersion
		   ,@ServiceMessageRequestID
		   ,@ServiceMessageResponseID
		   ,@Request
		   ,@Response
		   ,GETDATE()
		   ,@UserModified
		   ,GETDATE()
		   ,@UserModified
		   )

	SELECT  @intErrorCode = @@ERROR, 
			@HpiiLookupAuditId = SCOPE_IDENTITY()
	
	IF @intErrorCode = 0
	BEGIN
		SELECT 
			[HpiiLookupAuditId]
		   ,[HpiiNumber]
		   ,[HpiiStatusId]
		   ,[RegistrationId]
		   ,[FamilyName]
		   ,[GivenNames]
		   ,[DateOfBirth]
		   ,[SexId]
		   ,[AustralianStateId]
		   ,[Postcode]
		   ,[CountryId]
		   ,[BatchItemId]
		   ,[BatchId]
		   ,[Message]
		   ,[OperatorHpiI]
		   ,[HpiO]
		   ,[Operator]
		   ,[IdentifierType]
		   ,[IdentifierValue]
		   ,[HiWebServiceName]
		   ,[HiWebServiceVersion]
		   ,[ServiceMessageRequestID]
		   ,[ServiceMessageResponseID]
		   ,[Request]
		   ,[Response]
		   ,[DateCreated]
		   ,[UserCreated]
		   ,[DateModified]
		   ,[UserModified]
		 FROM [hips].[HpiiLookupAudit]
		 WHERE [HpiiLookupAuditId] = @HpiiLookupAuditId
	END

	RETURN(@intErrorCode)
END
GO

